/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.operation;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApplicationJar;

import java.util.HashMap;
import java.util.Map;

import io.qameta.allure.Description;
import org.junit.Before;
import org.junit.Test;

public class PolicyOperationErrorHandlingContinueTestCase extends PolicyOperationErrorHandlingScenarios {

  private Map<String, Object> config;

  public PolicyOperationErrorHandlingContinueTestCase(Boolean propagateMessageTransformations,
                                                      DynamicPort port,
                                                      ApplicationJar application) {
    super(propagateMessageTransformations, port, application);
  }

  @Before
  public void setUp() {
    config = new HashMap<>();
    config.put("errorContinue", true);
    config.put("errorPropagate", false);
    config.put("enablePropagation", propagateMessageTransformations);
  }

  @Description("One policy: error thrown before executing the server")
  @Test
  public void onePolicyExceptionBeforeExecuteNext() {
    policyDefinition = policyDefinition(1, OPERATION_BEFORE_NEXT_TEMPLATE_ID, setPayloadApiId(), config);
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.asString(), is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD));
      assertThat(response.statusCode(), is(200));
    });
  }

  @Description("One policy: error thrown in the server")
  @Test
  public void onePolicyErrorInServer() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInServerApiId(), config);
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInServerRequest.get();

      assertThat(response.asString(), is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown in the requester")
  @Test
  public void onePolicyErrorInRequester() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInRequesterApiId(), config);
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInRequesterRequest.get();

      assertThat(response.asString(), is(FLOW_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown when resolving target value defined in the requester")
  @Test
  public void onePolicyErrorInTargetValue() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInTargetValueApiId(), config);
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInTargetValueRequest.get();

      assertThat(response.asString(), is(FLOW_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown before executing the server, with a reduced scope, using on error continue.")
  @Test
  public void onePolicyExceptionBeforeExecuteNextWithReducedScope() {
    policyDefinition = policyDefinition(1, OPERATION_BEFORE_NEXT_REDUCED_TRY_SCOPE_TEMPLATE_ID, setPayloadApiId(), config);
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SERVER_PAYLOAD));
    });
  }
}
