/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.operation;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApplicationJar;

import java.util.HashMap;
import java.util.Map;

import io.qameta.allure.Description;
import org.junit.Test;

public class PolicyOperationErrorHandlingPropagateTestCase extends PolicyOperationErrorHandlingScenarios {

  public PolicyOperationErrorHandlingPropagateTestCase(Boolean propagateMessageTransformations,
                                                       DynamicPort port,
                                                       ApplicationJar application) {
    super(propagateMessageTransformations, port, application);
  }

  @Description("One policy: error thrown before executing the server")
  @Test
  public void onePolicyExceptionBeforeExecuteNext() {
    policyDefinition = policyDefinition(1, OPERATION_BEFORE_NEXT_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown before executing the server, with a reduced scope, using on error propagate.")
  @Test
  public void onePolicyExceptionBeforeExecuteNextWithReducedScope() {
    policyDefinition =
        policyDefinition(1, OPERATION_BEFORE_NEXT_REDUCED_TRY_SCOPE_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: specific error thrown before executing the server")
  @Test
  public void onePolicySpecificExceptionBeforeExecuteNext() {
    policyDefinition =
        policyDefinition(1, OPERATION_BEFORE_NEXT_SPECIFIC_EXCEPTION_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown after executing the server")
  @Test
  public void onePolicyExceptionAfterExecuteNext() {
    policyDefinition = policyDefinition(1, OPERATION_AFTER_NEXT_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + SERVER_PAYLOAD + AFTER_OPERATION_PAYLOAD
                     + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown in the server")
  @Test
  public void onePolicyErrorInServer() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInServerApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInServerRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown in the requester")
  @Test
  public void onePolicyErrorInRequester() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInRequesterApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInRequesterRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(), is(FLOW_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown when resolving target value defined in the requester")
  @Test
  public void onePolicyErrorInTargetValue() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInTargetValueApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInTargetValueRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(), is(FLOW_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("One policy: error thrown in the error handler")
  @Test
  public void onePolicyErrorInErrorHandler() {
    policyDefinition =
        policyDefinition(1, OPERATION_BEFORE_NEXT_AND_IN_ERROR_HANDLER_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Test
  public void onePolicyErrorBeforeHandledInFlow() {
    policyDefinition = policyDefinition(1, OPERATION_BEFORE_NEXT_TEMPLATE_ID, errorHandledInFlow(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorHandledInFlow.get();

      assertThat(response.statusCode(), is(200));
      // TODO: AGW-4355 Operation Policy Attributes are propagated to app under some error scenarios
      // assertThat(response.asString(), is(FLOW_PAYLOAD));
      assertThat(response.asString(), is(BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + FLOW_PAYLOAD));
    });
  }

  @Test
  public void onePolicyErrorInOperationHandledInFlow() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorHandledInFlow(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorHandledInFlow.get();

      assertThat(response.statusCode(), is(200));
      // TODO: AGW-4355 Operation Policy Attributes are propagated to app under some error scenarios
      // assertThat(response.asString(), is(FLOW_PAYLOAD));
      assertThat(response.asString(), is(BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + FLOW_PAYLOAD));
    });
  }

  @Test
  public void onePolicyErrorAfterHandledInFlow() {
    policyDefinition = policyDefinition(1, OPERATION_AFTER_NEXT_TEMPLATE_ID, getErrorHandledInFlowSuccess(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = errorHandledInFlowSuccess.get();

      assertThat(response.statusCode(), is(200));
      // TODO: AGW-4355 Operation Policy Attributes are propagated to app under some error scenarios
      // assertThat(response.asString(), is(FLOW_PAYLOAD));
      assertThat(response.asString(), is(BEFORE_OPERATION_PAYLOAD + SERVER_PAYLOAD + AFTER_OPERATION_PAYLOAD
          + OPERATION_ERROR_HANDLER_PAYLOAD + FLOW_PAYLOAD));
    });
  }

  @Description("Two policies: error thrown in the server")
  @Test
  public void twoPoliciesErrorInServer() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInServerApiId(), configData());
    server.deployPolicy(policyDefinition);

    policyDefinition2 = policyDefinition(2, OPERATION_NO_EXCEPTION_TEMPLATE_ID, errorInServerApiId(), configData());
    server.deployPolicy(policyDefinition2);

    serialExecutor.execute(() -> {
      HttpResponse response = errorInServerRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + BEFORE_OPERATION_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD
                     + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("Two policies: error thrown in the second one")
  @Test
  public void twoPoliciesErrorBeforeNextInSecondPolicy() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    policyDefinition2 = policyDefinition(2, OPERATION_BEFORE_NEXT_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition2);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + BEFORE_OPERATION_PAYLOAD
                     + OPERATION_ERROR_HANDLER_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD
                     + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Description("Two policies: error thrown in the second one")
  @Test
  public void twoPoliciesErrorAfterNextInSecondPolicy() {
    policyDefinition = policyDefinition(1, OPERATION_NO_EXCEPTION_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    policyDefinition2 = policyDefinition(2, OPERATION_AFTER_NEXT_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition2);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + BEFORE_OPERATION_PAYLOAD + SERVER_PAYLOAD + AFTER_OPERATION_PAYLOAD
                     + OPERATION_ERROR_HANDLER_PAYLOAD + OPERATION_ERROR_HANDLER_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  @Test
  @Description("One policy: error thrown before executing the server. No error handler")
  public void onePolicyExceptionBeforeExecuteNextWithoutErrorHandler() {
    policyDefinition =
        policyDefinition(1, OPERATION_BEFORE_NEXT_NO_ERROR_HANDLER_TEMPLATE_ID, setPayloadApiId(), configData());
    server.deployPolicy(policyDefinition);

    serialExecutor.execute(() -> {
      HttpResponse response = setPayloadRequest.get();

      assertThat(response.statusCode(), is(500));
      assertThat(response.asString(),
                 is(FLOW_PAYLOAD + BEFORE_OPERATION_PAYLOAD + SOURCE_ERROR_HANDLER_PAYLOAD));
    });
  }

  private Map<String, Object> configData() {
    Map<String, Object> result = new HashMap<>();
    result.put("errorContinue", false);
    result.put("errorPropagate", true);
    result.put("enablePropagation", propagateMessageTransformations);
    return result;
  }
}
