/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.operation;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.GROUP_ID;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.TestDependencies.testAssertionsDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;

import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.test.policy.error.PolicyErrorHandlingScenarios;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApiFinder;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApplicationJar;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.After;
import org.junit.ClassRule;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(Parameterized.class)
public abstract class PolicyOperationErrorHandlingScenarios extends PolicyErrorHandlingScenarios {

  protected static final PolicyTemplateKey OPERATION_AFTER_NEXT_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationAfterNext", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_BEFORE_NEXT_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationBeforeNext", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_BEFORE_NEXT_AND_IN_ERROR_HANDLER_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationBeforeNextAndInErrorHandler", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_BEFORE_NEXT_SPECIFIC_EXCEPTION_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationBeforeNextSpecificException", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_BEFORE_NEXT_NO_ERROR_HANDLER_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "NoErrorHandler", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_NO_EXCEPTION_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationNoException", "0.1.0");
  protected static final PolicyTemplateKey OPERATION_BEFORE_NEXT_REDUCED_TRY_SCOPE_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "OperationBeforeNextReducedScope", "0.1.0");

  protected static final int OVERRIDDEN_STATUS_CODE = 401;

  protected static final String BEFORE_SOURCE_PAYLOAD = "PolicySourceBefore-";
  protected static final String BEFORE_OPERATION_PAYLOAD = "PolicyOperationBefore-";
  protected static final String SOURCE_ERROR_HANDLER_PAYLOAD = "PolicySourceErrorHandler-";
  protected static final String OPERATION_ERROR_HANDLER_PAYLOAD = "PolicyOperationErrorHandler-";
  protected static final String AFTER_SOURCE_PAYLOAD = "PolicySourceAfter-";
  protected static final String AFTER_OPERATION_PAYLOAD = "PolicyOperationAfter-";
  protected static final String FLOW_PAYLOAD = "Flow-";
  protected static final String SERVER_PAYLOAD = "Server-";

  private static DynamicPort portApp1 = new DynamicPort("port");
  private static DynamicPort portApp2 = new DynamicPort("port2");
  private static DynamicPort implementationPort = new DynamicPort("implementation.port");

  private static SystemProperty beforeSourcePayload = new SystemProperty("beforeSourcePayload", BEFORE_SOURCE_PAYLOAD);
  private static SystemProperty beforeOperationPayload = new SystemProperty("beforeOperationPayload", BEFORE_OPERATION_PAYLOAD);
  private static SystemProperty sourceErrorHandlerPayload =
      new SystemProperty("sourceErrorHandlerPayload", SOURCE_ERROR_HANDLER_PAYLOAD);
  private static SystemProperty operationErrorHandlerPayload =
      new SystemProperty("operationErrorHandlerPayload", OPERATION_ERROR_HANDLER_PAYLOAD);
  private static SystemProperty afterSourcePayload = new SystemProperty("afterSourcePayload", AFTER_SOURCE_PAYLOAD);
  private static SystemProperty afterOperationPayload = new SystemProperty("afterOperationPayload", AFTER_OPERATION_PAYLOAD);
  private static SystemProperty serverPayload = new SystemProperty("serverPayload", SERVER_PAYLOAD);
  private static SystemProperty flowPayload = new SystemProperty("flowPayload", FLOW_PAYLOAD);
  private static SystemProperty overriddenStatusCode =
      new SystemProperty("overriddenStatusCode", String.valueOf(OVERRIDDEN_STATUS_CODE));

  private static ApplicationJar app1 = buildTestApplication(APP, "mule-config-error-handling-operation-http.xml",
                                                            testAssertionsDependency());
  private static ApplicationJar app2 = buildTestApplication(APP_2, "mule-config-error-handling-operation-http-target.xml",
                                                            testAssertionsDependency());

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(app1,
                            app2,
                            buildTestApplication("server", "mule-config-error-handling-operation-external-server.xml"))
          .withPolicyTemplates(
                               buildTestPolicyTemplate(OPERATION_AFTER_NEXT_TEMPLATE_ID,
                                                       "templates/operation/exception-in-operation-after-next-template.xml"),
                               buildTestPolicyTemplate(OPERATION_BEFORE_NEXT_AND_IN_ERROR_HANDLER_TEMPLATE_ID,
                                                       "templates/operation/exception-in-error-handler-template.xml"),
                               buildTestPolicyTemplate(OPERATION_BEFORE_NEXT_SPECIFIC_EXCEPTION_TEMPLATE_ID,
                                                       "templates/operation/specific-exception-in-operation-before-next-template.xml"),
                               buildTestPolicyTemplate(OPERATION_BEFORE_NEXT_TEMPLATE_ID,
                                                       "templates/operation/exception-in-operation-before-next-template.xml"),
                               buildTestPolicyTemplate(OPERATION_BEFORE_NEXT_NO_ERROR_HANDLER_TEMPLATE_ID,
                                                       "templates/operation/exception-in-operation-before-next-no-error-handler-template.xml"),
                               buildTestPolicyTemplate(OPERATION_NO_EXCEPTION_TEMPLATE_ID,
                                                       "templates/operation/operation-no-exception-thrown-template.xml"),
                               buildTestPolicyTemplate(OPERATION_BEFORE_NEXT_REDUCED_TRY_SCOPE_TEMPLATE_ID,
                                                       "templates/operation/exception-in-operation-before-next-reduced-try-scope-template.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(portApp1)
      .around(portApp2)
      .around(implementationPort)
      .around(beforeSourcePayload)
      .around(beforeOperationPayload)
      .around(sourceErrorHandlerPayload)
      .around(operationErrorHandlerPayload)
      .around(afterSourcePayload)
      .around(afterOperationPayload)
      .around(serverPayload)
      .around(flowPayload)
      .around(overriddenStatusCode)
      .around(installation);

  protected final Boolean propagateMessageTransformations;
  private final ApiFinder apiFinder;

  protected HttpRequest setPayloadRequest;
  protected HttpRequest errorInServerRequest;
  protected HttpRequest errorInRequesterRequest;
  protected HttpRequest errorInTargetValueRequest;
  protected HttpRequest errorHandledInFlow;
  protected HttpRequest errorHandledInFlowSuccess;

  protected PolicyDefinition policyDefinition;
  protected PolicyDefinition policyDefinition2;

  public PolicyOperationErrorHandlingScenarios(Boolean propagateMessageTransformations, DynamicPort port,
                                               ApplicationJar application) {
    this.propagateMessageTransformations = propagateMessageTransformations;
    this.setPayloadRequest = request(port, "/set-payload/server-resource");
    this.errorInServerRequest = request(port, "/error-in-server/server-error-in-response");
    this.errorInRequesterRequest = request(port, "/error-in-requester/");
    this.errorInTargetValueRequest = request(port, "/error-in-target-value/");
    this.errorHandledInFlow = request(port, "/error-handled-in-flow/");
    this.errorHandledInFlowSuccess = request(port, "/error-handled-in-flow-success/");
    this.apiFinder = new ApiFinder(application.getAppConfig());
  }

  @Parameterized.Parameters(name = "{index}: Propagating message modification: {0}")
  public static Object[][] parameters() {
    return new Object[][] {
        {false, portApp1, app1},
        {true, portApp1, app1},
        {false, portApp2, app2},
        {true, portApp2, app2}
    };
  }

  protected FakeGatewayServer server = installation.getServer();

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  protected ApiKey setPayloadApiId() {
    return apiFinder.find("set-payload");
  }

  protected ApiKey errorInServerApiId() {
    return apiFinder.find("error-in-server");
  }

  protected ApiKey errorInRequesterApiId() {
    return apiFinder.find("error-in-requester");
  }

  protected ApiKey errorInTargetValueApiId() {
    return apiFinder.find("error-in-target-value");
  }

  protected ApiKey errorHandledInFlow() {
    return apiFinder.find("error-handled-in-flow");
  }

  protected ApiKey getErrorHandledInFlowSuccess() {
    return apiFinder.find("error-handled-in-flow-success");
  }


}
