/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.operation;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.GROUP_ID;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.TestDependencies.testAssertionsDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import io.qameta.allure.Issue;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;

import com.mulesoft.anypoint.test.policy.scope.PolicyScopeTestCase;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tests.http.SimpleHttpServerResponse;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

@Issue("MULE-18434")
public class PolicyOperationOnFailingRequesterTestCase extends PolicyScopeTestCase {

  private static final PolicyTemplateKey NOOP_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "noop", "0.1.0");

  private static final String BACKEND_RESPONSE = "[\n  \"FIRST\",\n  \"CLE\"\n]";
  private static final Artifact APP_FOR_EACH =
      buildTestApplication(APP, "mule-config-http-with-proxy-foreach.xml", testAssertionsDependency());

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(APP_FOR_EACH)
          .withPolicyTemplates(buildTestPolicyTemplate(NOOP_TEMPLATE_KEY,
                                                       "policies/policy-noop-operation.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain ruleChain = RuleChain.outerRule(portApp1)
      .around(portApp2)
      .around(backend)
      .around(installation);

  private FakeGatewayServer server = installation.getServer();

  @Before
  public void setUp() {
    backend.getHttpServer().setResponse(SimpleHttpServerResponse.builder().body(BACKEND_RESPONSE).build());
  }

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  public void payloadPropagatesToRequest() {
    HttpRequest appendPayloadRequest = request(portApp1, "/");
    PolicyDefinition policyDefinition = policyDefinition(NOOP_TEMPLATE_KEY, new ApiKey(1L), true);

    server.deployPolicy(policyDefinition);

    HttpResponse response = appendPayloadRequest.get();

    assertThat(response.asString(), is(BACKEND_RESPONSE));
  }

}
