/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.source;

import java.util.Map;

import com.mulesoft.anypoint.test.policy.error.PolicyErrorHandlingScenarios;

public abstract class Configuration {

  private PolicyErrorHandlingScenarios.StatusCodeMode statusCodeMode;
  private PolicyErrorHandlingScenarios.HeadersMode headersMode;

  Configuration(PolicyErrorHandlingScenarios.StatusCodeMode statusCodeMode,
                PolicyErrorHandlingScenarios.HeadersMode headersMode) {
    this.statusCodeMode = statusCodeMode;
    this.headersMode = headersMode;
  }

  public PolicyErrorHandlingScenarios.StatusCodeMode getStatusCodeMode() {
    return statusCodeMode;
  }

  public PolicyErrorHandlingScenarios.HeadersMode getHeadersMode() {
    return headersMode;
  }

  /**
   * @return config data used to deploy the policies
   */
  abstract Map<String, Object> getConfigData();
}
