/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.source;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.GROUP_ID;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;

import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.test.policy.error.PolicyErrorHandlingScenarios;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.RuleChain;

public abstract class PolicySourceErrorHandlingInfrastructure extends PolicyErrorHandlingScenarios {

  protected static final PolicyTemplateKey AFTER_NEXT_TEMPLATE_ID = new PolicyTemplateKey(GROUP_ID, "AfterNext", "0.1.0");
  protected static final PolicyTemplateKey BEFORE_NEXT_TEMPLATE_ID = new PolicyTemplateKey(GROUP_ID, "BeforeNext", "0.1.0");
  protected static final PolicyTemplateKey BEFORE_NEXT_NESTED_TRY_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "BeforeNextReducedTryScope", "0.1.0");
  protected static final PolicyTemplateKey IN_ERROR_HANDLER_TEMPLATE_ID =
      new PolicyTemplateKey(GROUP_ID, "InErrorHandler", "0.1.0");
  protected static final PolicyTemplateKey NO_EXCEPTION_TEMPLATE_ID = new PolicyTemplateKey(GROUP_ID, "NoException", "0.1.0");
  protected static final PolicyTemplateKey POLICY_WITH_NESTED_TRY_THROWS_EXCEPTION =
      new PolicyTemplateKey(GROUP_ID, "NestedTryWithException", "0.1.0");
  protected static final PolicyTemplateKey POLICY_WITH_NESTED_TRY_NO_EXCEPTION =
      new PolicyTemplateKey(GROUP_ID, "NestedTryNoException", "0.1.0");

  protected static final int OVERRIDDEN_STATUS_CODE = 401;

  protected static final String AFTER_PAYLOAD = "AfterSource-";
  protected static final String BEFORE_PAYLOAD = "BeforeSource-";
  protected static final String POLICY_ERROR_PAYLOAD = "PolicyError-";
  protected static final String POLICY_SECOND_ERROR_PAYLOAD = "PolicySecondError-";
  protected static final String FLOW_PAYLOAD = "Flow-";
  protected static final String FLOW_ERROR_PAYLOAD = "FlowError-";
  protected static final String EXCEPTION_MESSAGE = "Error in flow";

  protected static final ApiKey SET_PAYLOAD_API_KEY = new ApiKey(1L);
  protected static final ApiKey SET_PAYLOAD_OVERRIDING_SC_API_KEY = new ApiKey(2L);
  protected static final ApiKey ERROR_API_KEY = new ApiKey(4L);
  protected static final ApiKey ERROR_RESPONSE_API_KEY = new ApiKey(5L);
  protected static final ApiKey ERROR_IN_RESPONSE_API_KEY = new ApiKey(6L);
  protected static final ApiKey ERROR_IN_ERROR_RESPONSE_API_KEY = new ApiKey(7L);
  protected static final ApiKey ERROR_CONTINUE_API_KEY = new ApiKey(8L);
  protected static final ApiKey ERROR_PROPAGATE_API_KEY = new ApiKey(9L);
  protected static final ApiKey ERROR_IN_ERROR_HANDLER_API_KEY = new ApiKey(10L);

  private static DynamicPort httpPort = new DynamicPort("port");

  private static SystemProperty throwErrorScript = new SystemProperty("throwErrorScript", "errorScript");
  private static SystemProperty afterPayload = new SystemProperty("afterPayload", AFTER_PAYLOAD);
  private static SystemProperty beforePayload = new SystemProperty("beforePayload", BEFORE_PAYLOAD);
  private static SystemProperty innerErrorPayload = new SystemProperty("innerErrorPayload", POLICY_SECOND_ERROR_PAYLOAD);
  private static SystemProperty flowPayload = new SystemProperty("flowPayload", FLOW_PAYLOAD);
  private static SystemProperty flowErrorPayload = new SystemProperty("flowErrorPayload", FLOW_ERROR_PAYLOAD);
  private static SystemProperty overriddenStatusCode =
      new SystemProperty("overriddenStatusCode", String.valueOf(OVERRIDDEN_STATUS_CODE));

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-error-handling-source-http.xml"))
          .withPolicyTemplates(
                               buildTestPolicyTemplate(AFTER_NEXT_TEMPLATE_ID,
                                                       "templates/source/exception-after-next-template.xml"),
                               buildTestPolicyTemplate(BEFORE_NEXT_TEMPLATE_ID,
                                                       "templates/source/exception-before-next-template.xml"),
                               buildTestPolicyTemplate(BEFORE_NEXT_NESTED_TRY_TEMPLATE_ID,
                                                       "templates/source/exception-before-next-nested-try-template.xml"),
                               buildTestPolicyTemplate(IN_ERROR_HANDLER_TEMPLATE_ID,
                                                       "templates/source/exception-in-error-handler-template.xml"),
                               buildTestPolicyTemplate(NO_EXCEPTION_TEMPLATE_ID,
                                                       "templates/source/no-exception-thrown-template.xml"),
                               buildTestPolicyTemplate(POLICY_WITH_NESTED_TRY_THROWS_EXCEPTION,
                                                       "templates/source/exception-in-policy-with-nested-try.xml"),
                               buildTestPolicyTemplate(POLICY_WITH_NESTED_TRY_NO_EXCEPTION,
                                                       "templates/source/policy-no-exception-nested-try.xml"))

          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(httpPort)
      .around(throwErrorScript)
      .around(afterPayload)
      .around(beforePayload)
      .around(innerErrorPayload)
      .around(flowPayload)
      .around(flowErrorPayload)
      .around(overriddenStatusCode)
      .around(installation);

  protected HttpRequest setPayloadRequest = request(httpPort, "/api/set-payload");
  protected HttpRequest setPayloadOverridingStatusCodeRequest =
      request(httpPort, "/api/set-payload-overriding-status-code-response");
  protected HttpRequest errorInErrorHandlerRequest = request(httpPort, "/api/error-in-error-handler");
  protected HttpRequest errorContinueRequest = request(httpPort, "/api/error-continue");
  protected HttpRequest errorPropagateRequest = request(httpPort, "/api/error-propagate");
  protected HttpRequest errorRequest = request(httpPort, "/api/error");
  protected HttpRequest errorResponseRequest = request(httpPort, "/api/error-response");
  protected HttpRequest errorInResponseBuilderRequest = request(httpPort, "/api/error-in-response");
  protected HttpRequest errorInErrorResponseBuilderRequest = request(httpPort, "/api/error-in-error-response");

  protected PolicyDefinition policyDefinition;
  protected PolicyDefinition policyDefinition2;

  protected FakeGatewayServer server = installation.getServer();

  protected static Map<String, Object> DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA;
  protected static Map<String, Object> DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA;
  protected static Map<String, Object> DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA;
  protected static Map<String, Object> ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA;

  @BeforeClass
  public static void beforeClass() {
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA = new HashMap<>();
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("errorContinue", true);
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("errorPropagate", false);
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("overrideStatusCode", false);
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("includeHeaders", false);
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("overrideStatusCodeOrIncludeHeaders", false);
    DEFAULT_ON_ERROR_CONTINUE_CONFIG_DATA.put("errorPayload", POLICY_SECOND_ERROR_PAYLOAD);

    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA = new HashMap<>();
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("errorContinue", false);
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("errorPropagate", true);
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("overrideStatusCode", false);
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("includeHeaders", false);
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("overrideStatusCodeOrIncludeHeaders", false);
    DEFAULT_ON_ERROR_PROPAGATE_CONFIG_DATA.put("errorPayload", POLICY_SECOND_ERROR_PAYLOAD);

    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA = new HashMap<>();
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("errorContinue", false);
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("errorPropagate", false);
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("overrideStatusCode", false);
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("includeHeaders", false);
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("overrideStatusCodeOrIncludeHeaders", false);
    DEFAULT_NO_ERROR_HANDLER_CONFIG_DATA.put("errorPayload", POLICY_SECOND_ERROR_PAYLOAD);

    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA = new HashMap<>();
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("errorContinue", false);
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("errorPropagate", true);
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("overrideStatusCode", true);
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("includeHeaders", true);
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("overrideStatusCodeOrIncludeHeaders", true);
    ON_ERROR_PROPAGATE_OVERRIDE_HEADERS_SC_CONFIG_DATA.put("errorPayload", POLICY_SECOND_ERROR_PAYLOAD);
  }

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

}
