/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.error.source;

import static com.mulesoft.anypoint.test.policy.error.PolicyErrorHandlingScenarios.HeadersMode.DONT_INCLUDE_HEADERS;
import static com.mulesoft.anypoint.test.policy.error.PolicyErrorHandlingScenarios.StatusCodeMode.DEFAULT_STATUS_CODE;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import java.util.HashMap;
import java.util.Map;

import com.mulesoft.anypoint.tests.http.HttpResponse;

public class PolicySourceNoErrorHandlerTestCase extends PolicySourceErrorHandlingScenarios {

  public PolicySourceNoErrorHandlerTestCase() {
    super(new ConfigurationImpl(DEFAULT_STATUS_CODE, DONT_INCLUDE_HEADERS));
  }

  /**
   * Asserts the generated status code when the error was thrown from a policy.
   *
   * Since there is no error-handler defined the status code will contain the value that the next chain generated (flow or another
   * policy). If the next chain does not complete with any status code, then a 500 ends up being set because the policy chain is
   * completing with an error
   */
  protected void assertVariableErrorStatusCode(HttpResponse response, int nextStatusCode) {
    int statusCode = nextStatusCode == NONE ? 500 : nextStatusCode;
    assertThat(response.statusCode(), is(statusCode));
  }

  /**
   * As there is no error-handler, then there is no additional payload appended by the policy, so we use an empty string
   */
  protected String policyErrorHandlerPayload() {
    return "";
  }

  public static class ConfigurationImpl extends Configuration {

    ConfigurationImpl(StatusCodeMode statusCodeMode, HeadersMode headersMode) {
      super(statusCodeMode, headersMode);
    }

    @Override
    public Map<String, Object> getConfigData() {
      Map<String, Object> result = new HashMap<>();
      result.put("errorContinue", false);
      result.put("errorPropagate", false);
      return result;
    }

  }
}
