/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.INVALID_POLICY_TEMPLATE_ID;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.contractsPolicyDefinition;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.invalidDefinition;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.policyDefinition;
import static com.mulesoft.anypoint.tests.CountProber.descriptiveCountProber;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_3;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_3;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.TestDependencies.contractsExtensionDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.anypoint.tests.infrastructure.rules.FakeApiServerRule;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;

public abstract class FlexibleGateKeeperTestCase extends AbstractMuleTestCase {

  static final ApiKey API_KEY_3 = new ApiKey(3L);
  static final ApiKey API_KEY_4 = new ApiKey(4L);
  public static final String APP_4 = "app4";

  static DynamicPort httpPort = new DynamicPort("port");
  static DynamicPort httpPort2 = new DynamicPort("port2");
  static DynamicPort httpPort3 = new DynamicPort("port3");
  static DynamicPort httpPort4 = new DynamicPort("port4");

  static DynamicPort apiPort = new DynamicPort("apiPort");

  static FakeApiServerRule fakeApiServerRule = new FakeApiServerRule(apiPort.getNumber());

  static SystemProperty platformUri =
      new SystemProperty("anypoint.platform.base_uri", "http://localhost:" + apiPort.getNumber() + "/test");

  static Artifact appWithGoodPolicy = buildTestApplication(APP, "mule-config-single-api.xml");
  static Artifact appWithBadPolicy = buildTestApplication(APP_2, "mule-config-single-different-api.xml");
  static Artifact appWithNoPolicy = buildTestApplication(APP_3, "mule-config-single-third-api.xml");
  static Artifact appWithContractsPolicy = buildTestApplication(APP_4, "mule-config-single-fourth-api.xml");
  static Artifact witnessApp = buildTestApplication("app5", "mule-config-witness.xml");

  HttpRequest request1 = request(httpPort, "/api/main").withTimeout(10000);
  HttpRequest request2 = request(httpPort2, "/api/main").withTimeout(10000);
  HttpRequest request3 = request(httpPort3, "/api/main").withTimeout(10000);
  HttpRequest request4 = request(httpPort4, "/api/main").withTimeout(10000);

  PolicyStoreFiles storeFiles;
  ContractRepository contractRepository;

  protected static FakeGatewayInstallation installation() {
    return builder()
        .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "templates/policy-template.xml"),
                             buildTestPolicyTemplate(INVALID_POLICY_TEMPLATE_ID, "templates/empty-template.xml"),
                             buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_3, "policies/policy-deployment-with-contracts.xml",
                                                     contractsExtensionDependency()))
        .withPolicyDefinitions(policyDefinition, invalidDefinition, contractsPolicyDefinition(API_KEY_4))
        .flexibleGateKeeper()
        .build();
  }

  protected void assertTrafficAllowed(boolean trafficAllowed) {
    assertThat(getServer().getHealthCheck().isInstanceTrafficAllowed(), is(trafficAllowed));
  }

  protected void probe(Runnable runnable) {
    descriptiveCountProber(50, 200, runnable);
  }

  protected abstract FakeGatewayServer getServer();

}
