/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.BLOCKED;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.UNBLOCKED;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD_2;
import static com.mulesoft.anypoint.tests.infrastructure.model.FakeApiModel.fakeModel;
import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR;

import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.MapDBContractRepository;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStoreFiles;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class FlexibleGatekeeperClientFailureTestCase extends FlexibleGateKeeperTestCase {

  public static final SystemProperty policyPayload2 = new SystemProperty("policyPayload2", POLICY_PAYLOAD_2);

  @ClassRule
  public static RuleChain chain = RuleChain.outerRule(httpPort)
      .around(httpPort2)
      .around(httpPort3)
      .around(httpPort4)
      .around(policyPayload2)
      .around(apiPort)
      .around(platformUri)
      .around(fakeApiServerRule);

  @Rule
  public FakeGatewayInstallation installation = getInstallation();

  private FakeGatewayInstallation getInstallation() {
    fakeModel().setCoreServicesMeStatus(INTERNAL_SERVER_ERROR.getStatusCode());
    return installation();
  }

  @Override
  protected FakeGatewayServer getServer() {
    return installation.getServer();
  }

  @Before
  public void setUp() {
    this.storeFiles = new PolicyStoreFiles(getServer().getPoliciesDir());
    this.contractRepository = new MapDBContractRepository();
  }

  @After
  public void tearDown() {
    contractRepository.dispose();
    getServer().removeAllPoliciesAndContext();
    fakeModel().clear();
  }

  @Test
  public void apiUnblockedWhenClientNotStarted() {
    getServer().deployApplications(appWithGoodPolicy);

    probe(() -> {
      HttpResponse response = request1.get();
      assertThat(response.statusCode(), is(UNBLOCKED));
      assertThat(response.asString(), is(POLICY_PAYLOAD));
      assertTrafficAllowed(true);
    });
  }

  @Test
  public void apiBlockedWhenClientNotStartedAndPolicyDeploymentFails() {
    getServer().deployApplications(appWithBadPolicy);

    getServer().deployApplications(witnessApp);

    probe(() -> {
      HttpResponse response = request2.get();
      assertThat(response.statusCode(), is(BLOCKED));
      assertThat(storeFiles.listPolicyDeploymentFailures(), hasSize(1));
    });

    assertTrafficAllowed(false);
  }

  @Test
  public void apiUnblockedWhenClientNotStartedAndNoPoliciesStored() {

    contractRepository.storeSlas(API_KEY_3, emptyList());

    getServer().deployApplications(appWithNoPolicy);

    probe(() -> {
      HttpResponse response = request3.get();
      assertThat(response.statusCode(), is(UNBLOCKED));
      assertTrafficAllowed(true);
    });
  }

  @Test
  public void apiBlockedWhenClientNotStartedForFirstDeployment() {
    getServer().deployApplications(appWithNoPolicy);

    getServer().deployApplications(witnessApp);

    probe(() -> {
      HttpResponse response = request3.get();
      assertThat(response.statusCode(), is(BLOCKED));
    });

    assertTrafficAllowed(false);
  }

  @Test
  public void apiBlockedWhenNoContracts() {
    getServer().deployApplications(appWithContractsPolicy);

    probe(() -> {
      HttpResponse response = request4.get();
      assertThat(response.statusCode(), is(BLOCKED));
    });

    assertTrafficAllowed(false);

  }

  @Test
  public void apiUnblockedWhenContracts() {
    contractRepository.store(API_KEY_4, emptyList());

    getServer().deployApplications(appWithContractsPolicy);

    probe(() -> {
      HttpResponse response = request4.get();
      assertThat(response.statusCode(), is(UNBLOCKED));
    });

    assertTrafficAllowed(true);

  }

}
