/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.BLOCKED;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.UNBLOCKED;
import static com.mulesoft.anypoint.test.policy.gatekeeper.GateKeeperTestData.encryptedPolicyDefinition;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.FLEXIBLE;
import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.STRICT;
import static com.mulesoft.mule.runtime.gw.model.PolicySet.PolicySetOrigin.PLATFORM;
import static java.util.Arrays.asList;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.junit.rules.RuleChain.outerRule;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.http.HttpResponse;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;

import java.util.Collection;

import org.apache.maven.model.Dependency;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(Parameterized.class)
public class GateKeeperStandaloneWithEncryption extends AbstractMuleTestCase {

  private static final String ENCRYPTION_KEY = "GatewayTeamKey00";
  private static final String PROPERTY_ENCRYPTION_KEY = "anypoint.platform.encryption_key";
  private static DynamicPort httpPort = new DynamicPort("port");

  @Rule
  public SystemProperty systemProperty = new SystemProperty(PROPERTY_ENCRYPTION_KEY, ENCRYPTION_KEY);

  @ClassRule
  public static RuleChain chain = outerRule(httpPort);

  private static Artifact application = buildTestApplication(APP, "mule-config-single-api.xml");

  private HttpRequest request = request(httpPort, "/api/main");

  private PolicySetDeploymentService policySetDeploymentService;

  private GateKeeperConfiguration.Mode mode;

  @Rule
  public FakeGatewayInstallation installation;
  private TestDownloaderListener deploymentListener;

  @Parameterized.Parameters(name = "{0} GateKeeper")
  public static Collection<Object[]> data() {
    return asList(new Object[][] {
        {STRICT},
        {FLEXIBLE}
    });
  }

  public GateKeeperStandaloneWithEncryption(GateKeeperConfiguration.Mode mode) {
    this.mode = mode;
    this.installation = installation();
  }

  @Before
  public void setUp() {
    policySetDeploymentService = installation.getServer().getPolicySetDeploymentService();

    deploymentListener = new TestDownloaderListener();
    policySetDeploymentService.addPolicyDeploymentListener(deploymentListener);
    installation.getServer().getApiService().addApiContractsListener(deploymentListener);
  }

  @After
  public void tearDown() {
    installation.getServer().removeAllPoliciesAndContext();
  }

  @Test
  public void gatekeeperIsUnblockedWhenDeployingAnEncryptedPolicy() {
    assertThat(request.get().statusCode(), is(BLOCKED));
    assertInstanceTrafficAllowed(false);

    policySetDeploymentService.policiesForApi(API_KEY, new PolicySet(newArrayList(encryptedPolicyDefinition), PLATFORM));

    deploymentListener.waitPoliciesUpdated();
    HttpResponse response = request.get();

    assertThat(request.get().statusCode(), is(UNBLOCKED));
    assertThat(response.asString(), is(POLICY_PAYLOAD));
    assertInstanceTrafficAllowed(true);
  }

  private FakeGatewayInstallation installation() {
    FakeGatewayInstallation.Builder builder = builder()
        .withApplications(application)
        .withPolicyTemplates(
                             buildTestPolicyTemplate(POLICY_TEMPLATE_KEY_2, "templates/policy-encrypted.xml", "/spec.yaml",
                                                     securePropertiesModule()))
        .offline();

    if (mode.equals(FLEXIBLE)) {
      builder.flexibleGateKeeper();
    }

    return builder.build();
  }

  /**
   * Maven's dependency of mule-secure-configuration-property-module
   */
  private static Dependency securePropertiesModule() {
    Dependency dependency = new Dependency();

    dependency.setGroupId("com.mulesoft.modules");
    dependency.setArtifactId("mule-secure-configuration-property-module");
    dependency.setVersion("1.0.2");
    dependency.setClassifier("mule-plugin");

    return dependency;
  }

  private void assertInstanceTrafficAllowed(boolean trafficAllowed) {
    assertThat(installation.getServer().getHealthCheck().isInstanceTrafficAllowed(), is(trafficAllowed));
  }

}
