/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import static com.google.common.collect.ImmutableMap.of;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_3;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_3;
import static java.util.Collections.emptyMap;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

public class GateKeeperTestData {

  protected static final int BLOCKED = 503;
  protected static final int UNBLOCKED = 200;

  protected static final PolicyTemplateKey INVALID_POLICY_TEMPLATE_ID =
      new PolicyTemplateKey("com.mulesoft.anypoint", "invalid-template-id", "0.1.0");

  protected static PolicyDefinition policyDefinition =
      new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, null, 1,
                           new PolicyConfiguration(of("payload", POLICY_PAYLOAD)));

  protected static PolicyDefinition encryptedPolicyDefinition =
      new PolicyDefinition(POLICY_ID_2, POLICY_TEMPLATE_KEY_2, API_KEY, null, 1,
                           new PolicyConfiguration(of("payload", POLICY_PAYLOAD)));

  protected static PolicyDefinition contractsPolicyDefinition(ApiKey key) {
    return new PolicyDefinition(POLICY_ID_3, POLICY_TEMPLATE_KEY_3, key, null, 1,
                                new PolicyConfiguration(of("apiId", key.id().toString())));
  }

  protected static PolicyDefinition contractsPolicyDefinition = contractsPolicyDefinition(API_KEY);

  protected static PolicyDefinition invalidDefinition =
      new PolicyDefinition(POLICY_ID_2, INVALID_POLICY_TEMPLATE_ID, API_KEY_2, null, 1, new PolicyConfiguration(emptyMap()));

}
