/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;

public class GatekeeperStatusInspector {

  private final Inspector inspector;

  public GatekeeperStatusInspector(GatekeeperStatusTracker status) {
    this.inspector = new Inspector(status);
  }

  public boolean policiesApplied() {
    return inspector.read("policiesApplied");
  }

  public boolean requiresContracts() {
    return inspector.read("requiresContracts");
  }

  public boolean contractsAvailable() {
    return inspector.read("contractsAvailable");
  }

}
