/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.gatekeeper;

import static java.util.concurrent.TimeUnit.SECONDS;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;

import java.util.List;
import java.util.concurrent.Semaphore;

public class TestDownloaderListener implements PolicySetDeploymentListener, ApiContractsListener {

  private Semaphore contractsSemaphore;
  private Semaphore policiesSemaphore;
  private Semaphore policiesRemovedSemaphore;
  private Semaphore prefetchSemaphore;

  public TestDownloaderListener() {
    this.contractsSemaphore = new Semaphore(0, false);
    this.policiesSemaphore = new Semaphore(0, false);
    this.policiesRemovedSemaphore = new Semaphore(0, false);
    this.prefetchSemaphore = new Semaphore(0, false);
  }

  @Override
  public void onContractsRequired(Api api) {
    prefetchSemaphore.release();
  }

  @Override
  public void onContractsLoaded(ApiKey apiKey) {
    contractsSemaphore.release();
  }

  @Override
  public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet,
                                             List<PolicyDeploymentStatus> deploymentStatuses) {
    policiesSemaphore.release();
  }

  @Override
  public void onPoliciesRemoved(ApiKey apiKey) {
    policiesRemovedSemaphore.release();
  }

  public TestDownloaderListener waitPoliciesUpdated() {
    return acquire(policiesSemaphore, "onPolicySetDeploymentCompleted");
  }

  public TestDownloaderListener waitPoliciesRemoved() {
    return acquire(policiesRemovedSemaphore, "onPoliciesRemoved");
  }

  public TestDownloaderListener waitContractsUpdated() {
    return acquire(contractsSemaphore, "onContractsDownloaded");
  }

  public TestDownloaderListener waitContractsPrefetch() {
    return acquire(prefetchSemaphore, "onContractsRequired");
  }

  private TestDownloaderListener acquire(Semaphore semaphore, String method) {
    try {
      if (!semaphore.tryAcquire(20, SECONDS)) {
        throw new AssertionError(method + " was never called.");
      }
    } catch (InterruptedException e) {
      throw new AssertionError("Interrupted while waiting for method " + method + " to be called.");
    }
    return this;
  }

}
