/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.offline;

import static com.mulesoft.anypoint.tests.CountProber.descriptiveCountProber;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_3;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.FAILED_POLICIES_FOLDER;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.getOfflinePoliciesFolder;
import static com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore.POLICY_DEFINITION_JSON_FILE_NAME;
import static org.apache.commons.io.FileUtils.copyFile;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.policies.store.DefaultPolicyStore;
import com.mulesoft.mule.runtime.gw.policies.store.EncryptedPropertiesSerializer;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class OfflinePolicyMultipleApisTestCase extends AbstractMuleTestCase {

  @Override
  public int getTestTimeoutSecs() {
    return 120;
  }

  @ClassRule
  public static DynamicPort port = new DynamicPort("port");

  @ClassRule
  public static DynamicPort port2 = new DynamicPort("port2");

  @ClassRule
  public static DynamicPort port3 = new DynamicPort("port3");

  @Rule
  public FakeGatewayInstallation installation =
      builder()
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "templates/policy-template.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  private PolicyStore policyStore = new DefaultPolicyStore(new EncryptedPropertiesSerializer());

  @Test
  public void offlinePolicyWithMultipleApisInSameAppIsApplied() throws IOException, URISyntaxException {
    copyFile(multipleApisDefinitionFile(), new File(getOfflinePoliciesFolder(), POLICY_DEFINITION_JSON_FILE_NAME));

    Artifact application = buildTestApplication(APP, "mule-config-multiple-apis.xml");
    installation.getServer().deployApplications(application);

    checkDeployedPolicy(request(port, "/api/flow1"));
    checkDeployedPolicy(request(port, "/api/flow2"));
    assertThat(policyStore.offlinePolicies(), hasSize(1));
    assertThat(policyStore.load(), hasSize(1));
  }

  @Test
  public void offlinePolicyWithMultipleApisInDifferentAppsDoesNotLogError() throws IOException, URISyntaxException {
    copyFile(multipleApisDefinitionFile(), new File(getOfflinePoliciesFolder(), POLICY_DEFINITION_JSON_FILE_NAME));

    Artifact application1 = buildTestApplication(APP, "mule-config-single-api.xml");
    Artifact application2 = buildTestApplication(APP_2, "mule-config-single-different-api.xml");
    Artifact application3 = buildTestApplication(APP_3, "mule-config-single-third-api.xml");
    installation.getServer().deployApplications(application1, application2, application3);

    checkDeployedPolicy(request(port, "/api/main"));
    checkDeployedPolicy(request(port2, "/api/main"));
    check(() -> assertThat(request(port3, "/api/main").get().asString(), is("")));

    check(() -> assertThat("Failed policies files should not exist", failedPoliciesFolder().exists(), is(false)));
  }

  private void check(Runnable asserter) {
    descriptiveCountProber(100, asserter);
  }

  private void checkDeployedPolicy(HttpRequest request) {
    check(() -> assertThat(request.get().asString(), is(POLICY_PAYLOAD)));
  }

  private File multipleApisDefinitionFile() throws URISyntaxException {
    return new File(getClass().getResource("/json/offline-multiple-apis-definition.json").toURI());
  }

  private File failedPoliciesFolder() {
    return new File(installation.getServer().getMuleHome(), "policies/" + FAILED_POLICIES_FOLDER);
  }

}
