/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.scope;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP_3;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID_2;
import static com.mulesoft.anypoint.tita.TestDependencies.smartConnectorUsingHttpDependency;
import static com.mulesoft.anypoint.tita.TestDependencies.testAssertionsDependency;
import static com.mulesoft.anypoint.tita.TestDependencies.testAuthenticationDependency;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.anypoint.tests.rules.HttpServerRule;
import com.mulesoft.anypoint.tita.environment.api.artifact.ApiFinder;
import com.mulesoft.anypoint.tita.environment.api.artifact.Artifact;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.HashMap;
import java.util.Map;

public class PolicyScopeTestCase extends AbstractMuleTestCase {

  protected static DynamicPort portApp1 = new DynamicPort("port");
  protected static DynamicPort portApp2 = new DynamicPort("port2");
  protected static DynamicPort portApp3 = new DynamicPort("port3");

  protected static HttpServerRule backend = new HttpServerRule("httpPort");

  protected static Artifact app1 = buildTestApplication(APP, "mule-config-http-with-proxy.xml", testAssertionsDependency(),
                                                        testAuthenticationDependency());

  protected static Artifact app2 = buildTestApplication(APP_2, "mule-config-http-with-smart-connector-proxy.xml",
                                                        testAssertionsDependency(), testAuthenticationDependency(),
                                                        smartConnectorUsingHttpDependency());

  protected static Artifact app3 = buildTestApplication(APP_3, "mule-config-http-with-proxy-target.xml",
                                                        testAssertionsDependency(), testAuthenticationDependency(),
                                                        smartConnectorUsingHttpDependency());

  protected ApiFinder apiFinder;

  protected PolicyDefinition policyDefinition(PolicyTemplateKey templateKey, ApiKey apiKey, Boolean propagationEnabled) {
    return policyDefinition(POLICY_ID, templateKey, apiKey, 1, propagationEnabled);
  }

  protected PolicyDefinition secondPolicy(PolicyTemplateKey templateKey, ApiKey apiKey, Boolean propagationEnabled) {
    return policyDefinition(POLICY_ID_2, templateKey, apiKey, 2, propagationEnabled);
  }

  private PolicyDefinition policyDefinition(String id, PolicyTemplateKey templateKey, ApiKey apiKey, int order,
                                            Boolean propagationEnabled) {
    Map<String, Object> configData = new HashMap<>();
    configData.put("propagationEnabled", propagationEnabled.toString());
    return new PolicyDefinition(id, templateKey, apiKey, null, order, new PolicyConfiguration(configData));
  }

  public ApiKey getEmptyApiKey() {
    return apiFinder.find("empty");
  }

  public ApiKey getAppendPayloadApiKey() {
    return apiFinder.find("append-payload");
  }

  public ApiKey getVariablesApiKey() {
    return apiFinder.find("variables");
  }

  public ApiKey getSecurityContextApiKey() {
    return apiFinder.find("security-context");
  }

  public ApiKey getRequesterWithUrlApiKey() {
    return apiFinder.find("requester-with-url");
  }

}
