/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.test.policy.scope.source;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.APP;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.FLOW_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.GROUP_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_PAYLOAD_2;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.anypoint.tests.http.ApacheHttpRequest.request;
import static com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation.builder;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestApplication;
import static com.mulesoft.anypoint.tita.environment.artifact.ArtifactProvider.buildTestPolicyTemplate;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.anypoint.test.policy.scope.PolicyScopeTestCase;
import com.mulesoft.anypoint.tests.http.HttpRequest;
import com.mulesoft.anypoint.tests.infrastructure.FakeGatewayServer;
import com.mulesoft.anypoint.tests.infrastructure.installation.FakeGatewayInstallation;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;


public class PolicyScopePayloadTestCase extends PolicyScopeTestCase {

  private static final ApiKey APPEND_PAYLOAD_API_KEY = new ApiKey(3L);

  private static final PolicyTemplateKey NOOP_TEMPLATE_KEY =
      new PolicyTemplateKey(GROUP_ID, "noop", "0.1.0");

  private static final String POLICY_PAYLOAD_PARAM = "policyPayload";

  private static FakeGatewayInstallation installation =
      builder()
          .withApplications(buildTestApplication(APP, "mule-config-http.xml"))
          .withPolicyTemplates(buildTestPolicyTemplate(POLICY_TEMPLATE_KEY, "policies/policy-scope-payload-policy.xml"),
                               buildTestPolicyTemplate(NOOP_TEMPLATE_KEY,
                                                       "policies/policy-noop-source.xml"))
          .gateKeeperDisabled()
          .offline()
          .build();

  @ClassRule
  public static RuleChain ruleChain = RuleChain.outerRule(portApp1).around(installation);

  private HttpRequest appendPayloadRequest = request(portApp1, "/api/append-payload");
  private HttpRequest emptyRequest = request(portApp1, "/api/empty");

  private FakeGatewayServer server = installation.getServer();

  @After
  public void tearDown() {
    server.removeAllPoliciesAndContext();
  }

  @Test
  public void payloadPropagates() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, true);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);

    server.deployPolicy(policyDefinition);

    assertThat(appendPayloadRequest.get().asString(), is(POLICY_PAYLOAD + FLOW_PAYLOAD + POLICY_PAYLOAD));
  }

  @Test
  public void payloadDoesNotPropagateWhenDisabled() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);

    server.deployPolicy(policyDefinition);

    assertThat(appendPayloadRequest.get().asString(), is(FLOW_PAYLOAD + POLICY_PAYLOAD));
  }

  @Test
  public void multiplePoliciesPayloadScopePropagates() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, true);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);
    PolicyDefinition policyDefinition2 = secondPolicy(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, true);
    policyDefinition2.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD_2);

    server.deployPolicy(policyDefinition);
    server.deployPolicy(policyDefinition2);

    assertThat(appendPayloadRequest.get().asString(),
               is(POLICY_PAYLOAD + POLICY_PAYLOAD_2 + FLOW_PAYLOAD + POLICY_PAYLOAD_2 + POLICY_PAYLOAD));
  }

  @Test
  public void multiplePoliciesPayloadDoesNotPropagate() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);
    PolicyDefinition policyDefinition2 = secondPolicy(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);
    policyDefinition2.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD_2);

    server.deployPolicy(policyDefinition);
    server.deployPolicy(policyDefinition2);

    assertThat(appendPayloadRequest.get().asString(),
               is(FLOW_PAYLOAD + POLICY_PAYLOAD_2 + POLICY_PAYLOAD));
  }

  @Test
  public void multiplePoliciesMixPropagationPayload() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, true);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);
    PolicyDefinition policyDefinition2 = secondPolicy(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);
    policyDefinition2.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD_2);

    server.deployPolicy(policyDefinition);
    server.deployPolicy(policyDefinition2);

    assertThat(appendPayloadRequest.get().asString(),
               is(POLICY_PAYLOAD + FLOW_PAYLOAD + POLICY_PAYLOAD_2 + POLICY_PAYLOAD));
  }

  @Test
  public void multiplePoliciesMixPropagationPayloadInverted() {
    PolicyDefinition policyDefinition = policyDefinition(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);
    policyDefinition.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD);
    PolicyDefinition policyDefinition2 = secondPolicy(POLICY_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, true);
    policyDefinition2.getConfigurationData().getConfiguration().put(POLICY_PAYLOAD_PARAM, POLICY_PAYLOAD_2);

    server.deployPolicy(policyDefinition);
    server.deployPolicy(policyDefinition2);

    assertThat(appendPayloadRequest.get().asString(),
               is(POLICY_PAYLOAD_2 + FLOW_PAYLOAD + POLICY_PAYLOAD_2 + POLICY_PAYLOAD));
  }

  @Test
  public void payloadUntouchedWhenPolicyDoesNotChangeIt() {
    String postPayload = "Post Payload";
    PolicyDefinition policyDefinition = policyDefinition(NOOP_TEMPLATE_KEY, APPEND_PAYLOAD_API_KEY, false);

    server.deployPolicy(policyDefinition);

    assertThat(emptyRequest.withPayload(postPayload).post().asString(), is(postPayload));
  }

}
