/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.injector;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderInjector.class);
    private final Introspectors<HttpAttributesIntrospector> introspectors = new Introspectors<HttpAttributesIntrospector>(HttpAttributesIntrospector::new);

    protected void injectHeader(Object attributes, String name, String value) {
        try {
            HttpAttributesIntrospector introspector = this.introspectors.getFor(attributes.getClass());
            CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap(introspector.getHeaders(attributes));
            headers.put((Object)name, (Object)value);
            introspector.getHeadersField().set(attributes, headers);
        }
        catch (IllegalAccessException e) {
            LOGGER.debug(String.format("Could not set header \"%s\": \"%s\" for the response event.", name, value), (Throwable)e);
        }
    }
}

