/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static org.mule.runtime.core.api.config.MuleManifest.getProductVersion;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.deployment.InternalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.ClasspathPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.FileSystemPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;

public class AnalyticsApiDeploymentListener implements ApiDeploymentListener {

  private static final String ANALYTICS_POLICY_ID = "analytics-policy";
  private static final PolicyTemplateKey ANALYTICS_POLICY_TEMPLATE_KEY = new PolicyTemplateKey("com.mulesoft.anypoint",
                                                                                               "mule-analytics-policy-template",
                                                                                               getProductVersion());

  private PolicyDeployer policyDeployer = new InternalPolicyDeployer();
  private PolicyFactory policyFactory = new DefaultPolicyFactory(new HandlebarsPolicyTemplateResolver(),
                                                                 new ClasspathPolicyTemplateProvider());

  /**
   * Applying an empty policy to an API implementation is a work-around to obtain status codes when the API does not have any
   * other policy deployed. This is happening because when there are no policies applied, the event that goes through MULE's
   * pipeline does not contain the response attributes at any time. A fix for this is to hear for HTTP notifications once they are
   * in place
   */
  @Override
  public void onApiDeploymentSuccess(Api api) {
    if (!api.getImplementation().isHdp()) {
      PolicyDefinition policyDefinition = new OfflinePolicyDefinition(getPolicyId(api), ANALYTICS_POLICY_TEMPLATE_KEY,
                                                                      api.getImplementation().getApiKey(), emptyList(), 1,
                                                                      new PolicyConfiguration(emptyMap()));
      policyDeployer.deploy(policyFactory.createFromPolicyDefinition(policyDefinition), api);
    }
  }

  private String getPolicyId(Api api) {
    return ANALYTICS_POLICY_ID + "-" + api.getKey().id();
  }
}
