/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import static java.util.Optional.empty;

import com.mulesoft.mule.runtime.gw.analytics.extractor.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.analytics.servicemesh.ServiceMeshHeaderInjector;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;

/**
 * ServiceMesh mode handler that returns the request analytics information in a header
 * and does not push the events to the analytics queues.
 */
public class AnalyticsServiceMeshEventHandler extends AnalyticsEventHandler {

  private final ServiceMeshHeaderInjector meshHeaderInjector = new ServiceMeshHeaderInjector();

  public AnalyticsServiceMeshEventHandler(String muleAppName, ApiService apiService,
                                          EnrichedServerNotificationExtractor extractor,
                                          EventsCollectorService eventsCollectorService) {
    super(muleAppName, apiService, extractor, null, eventsCollectorService, empty());
  }

  @Override
  void dispatchEvent(AnalyticsHttpEvent event, Object attributes) {
    meshHeaderInjector.injectHeader(attributes, event);
  }

}
