/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.introspector;

import static org.apache.commons.lang3.reflect.MethodUtils.getAccessibleMethod;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HttpResponseAttributesIntrospector extends HttpAttributesIntrospector {

  private final Method statusCodeMethod;

  public HttpResponseAttributesIntrospector(Class cls) {
    super(cls);
    this.statusCodeMethod = getAccessibleMethod(cls, "getStatusCode");
  }

  public int getStatusCode(Object attributesValue) throws IllegalAccessException, InvocationTargetException {
    return (int) statusCodeMethod.invoke(attributesValue);
  }

}
