/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.core.api.construct.Flow;

import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.model.Api;

import java.util.OptionalLong;

public interface AnalyticsEventBuilder {

  // TODO: AGW-1265: When RestClient is decoupled from analytics, this builder should return a generic AnalyticsEvent
  AnalyticsHttpEvent build();

  AnalyticsEventBuilder withApi(Api api);

  AnalyticsEventBuilder withRequest(OptionalLong payloadLength, TypedValue<Object> requestAttributes);

  AnalyticsEventBuilder withId(String id);

  AnalyticsEventBuilder withReceivedTimestamp(long timestamp);

  AnalyticsEventBuilder withRepliedTimestamp(long timestamp);

  AnalyticsEventBuilder withPolicyViolation(PolicyViolation policyViolation);

  AnalyticsEventBuilder withResponse(OptionalLong payloadLength, TypedValue<Object> responseAttributes, IntegerAction action);

  AnalyticsEventBuilder withClient(Client client);

  AnalyticsHttpEventBuilder withMuleAppName(String muleAppName);

  AnalyticsHttpEventBuilder withFlowName(String flowName);

  boolean isEdgeRequest();

  String getApiDescription();
}
