/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.feedbackloop;

import static com.beust.jcommander.internal.Lists.newArrayList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.junit.Test;

public class EdgeRequestDetectorTestCase {

  private EdgeRequestDetector edgeRequestDetector = new EdgeRequestDetector();

  @Test
  public void detectEdgeRequest() {
    assertThat(edgeRequestDetector.isEdgeRequest(newArrayList("EDGE/1.1 MuleSoft")), is(true));
  }

  @Test
  public void donNotDetectNonRegexMatchingVia() {
    assertThat(edgeRequestDetector.isEdgeRequest(newArrayList("EDGE/1.1 uleSoft")), is(false));
  }

  @Test
  public void donNotDetectNonRegexMatchingViaCommaSeparated() {
    assertThat(edgeRequestDetector.isEdgeRequest(newArrayList("EDGE/1.1 uleSoft,EDGE/1.1 uleSoft")), is(false));
  }

  @Test
  public void detectNonRegexMatchingViaCommaSeparated() {
    assertThat(edgeRequestDetector.isEdgeRequest(newArrayList("EDGE/1.1 uleSoft,EDGE/1.1 MuleSoft")), is(true));
  }

  @Test
  public void donNotDetectNonEdgeRequest() {
    assertThat(edgeRequestDetector.isEdgeRequest(newArrayList()), is(false));
  }

}
