/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.feedbackloop;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.util.MultiMap;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributes;

import org.junit.Test;

public class EventAttributesIntrospectorTestCase {

  private static final String HEADER_NAME1 = "header1";
  private static final String HEADER_VALUE1 = "value1";
  private static final String HEADER_NAME2 = "header2";
  private static final String HEADER_VALUE2 = "value2";

  private MultiMap<String, String> originalHeaders;
  private MultiMap<String, String> newHeaders;

  public EventAttributesIntrospectorTestCase() {
    MultiMap<String, String> map = new MultiMap<>();
    map.put(HEADER_NAME1, HEADER_VALUE1);
    this.originalHeaders = map.toImmutableMultiMap();
    map.put(HEADER_NAME2, HEADER_VALUE2);
    this.newHeaders = map.toImmutableMultiMap();
  }

  @Test
  public void injectHeaderToHttpResponseAttributes() throws IllegalAccessException {
    HttpAttributesIntrospector introspector = new HttpAttributesIntrospector(HttpResponseAttributes.class);
    HttpResponseAttributes attributes = new HttpResponseAttributes(originalHeaders, 200);

    assertThat(introspector.getHeaders(attributes), is(originalHeaders));
    introspector.getHeadersField().set(attributes, newHeaders);
    assertThat(attributes.getHeaders(), is(newHeaders));
  }

  @Test
  public void injectHeaderToNewClass() throws IllegalAccessException {
    HttpAttributesIntrospector introspector = new HttpAttributesIntrospector(TestAttributeClass.class);
    TestAttributeClass attributes = new TestAttributeClass();
    attributes.headers = originalHeaders;
    assertThat(introspector.getHeaders(attributes), is(originalHeaders));
    introspector.getHeadersField().set(attributes, newHeaders);
    assertThat(attributes.headers, is(newHeaders));
  }

}
