/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.introspector;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;
import com.mulesoft.mule.runtime.gw.analytics.model.Dummy;

import org.junit.Test;

public class InstrospectorsTestCase {

  @Test
  public void getIntrospector() {
    Introspectors<Dummy> introspectors = new Introspectors<>(Dummy::new);
    assertThat(introspectors.getFor(Dummy.class), is(introspectors.getFor(Dummy.class)));
    assertThat(introspectors.getFor(Dummy.class), not(is(introspectors.getFor(String.class))));
    assertThat(introspectors.size(), is(2));
  }

}
