/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.runnable;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class AnalyticsPolicyIdTestCase {

  private static final String RESOLVED_TEMPLATE = "resolvedTemplate";

  @Captor
  private ArgumentCaptor<PolicyDefinition> captor;

  private Long apiId = 101L;
  private ApiKey apiKey = mock(ApiKey.class);
  private ApiImplementation apiImplementation = mock(ApiImplementation.class);
  private Api api = mock(Api.class);
  private PolicyDeployer policyDeployer = mock(PolicyDeployer.class);
  private PolicyFactory policyFactory = mock(PolicyFactory.class);

  private Policy policy;

  @Mock
  private PolicyTemplate policyTemplate;

  @Before
  public void setup() {
    when(apiKey.id()).thenReturn(apiId);
    when(apiImplementation.getApiKey()).thenReturn(apiKey);
    when(api.getImplementation()).thenReturn(apiImplementation);
    when(api.getKey()).thenReturn(apiKey);

    PolicyDefinition policyDefinition = captor.capture();
    policy = new Policy(policyTemplate, policyDefinition, RESOLVED_TEMPLATE);
    when(policyFactory.createFromPolicyDefinition(policyDefinition)).thenReturn(policy);
  }

  @Test
  public void policyId() throws Exception {
    AnalyticsApiDeploymentListener analyticsApiDeploymentListener = new AnalyticsApiDeploymentListener();
    VariableOverride.overrideVariable("policyDeployer").in(analyticsApiDeploymentListener).with(policyDeployer);
    VariableOverride.overrideVariable("policyFactory").in(analyticsApiDeploymentListener).with(policyFactory);

    analyticsApiDeploymentListener.onApiDeploymentSuccess(api);

    verify(policyDeployer).deploy(policy, api);
    assertThat(captor.getValue().getId(), is("analytics-policy-" + apiId));
  }

}
