/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.runnable;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.session.metadata.ApiPlatformSessionMetadata;
import com.mulesoft.mule.runtime.gw.retry.session.ErrorSessionMetadata;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventSenderRunnable
extends BackoffRunnable {
    private static final String SEND_ANALYTICS_DESCRIPTION = "send events to analytics ingest from";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventSenderRunnable.class);
    private final NormalizedExceptionMessageLogger normalizedLogger = new RecoverableExceptionMessageLogger(LOGGER);
    private final ApiPlatformClient restClient;
    private final int batchSize;
    private AnalyticsEventCache cache;

    public AnalyticsEventSenderRunnable(AnalyticsEventCache eventRepository, int batchSize, ApiPlatformClient restClient, BackoffConfiguration backoffConfiguration, BackoffBarrier backoffBarrier) {
        super(backoffConfiguration, backoffBarrier);
        this.cache = eventRepository;
        this.restClient = restClient;
        this.batchSize = batchSize;
    }

    protected SessionMetadata execute() {
        int statusCode = 200;
        try {
            if (this.restClient.isConnected()) {
                if (this.cache.isEmpty()) {
                    LOGGER.trace("{} queue is empty, skipping run.", (Object)this.cache.getName());
                } else {
                    ArrayList<AnalyticsHttpEvent> events = new ArrayList<AnalyticsHttpEvent>();
                    AnalyticsHttpEvent event = this.cache.poll();
                    while (events.size() < this.batchSize && event != null) {
                        events.add(event);
                        event = this.cache.poll();
                    }
                    LOGGER.trace("Attempting to send {} events from {} to analytics ingest.", (Object)events.size(), (Object)this.cache.getName());
                    try {
                        statusCode = this.restClient.postHttpEvents(events);
                        LOGGER.debug("{} events from {} were sent to analytics ingest.", (Object)events.size(), (Object)this.cache.getName());
                    }
                    catch (Exception e) {
                        this.normalizedLogger.warn(SEND_ANALYTICS_DESCRIPTION, (Object)this.cache.getName(), (Throwable)e);
                        this.cache.addAll((Collection<? extends AnalyticsHttpEvent>)events);
                        statusCode = 503;
                    }
                }
            }
        }
        catch (Throwable t) {
            this.normalizedLogger.error(SEND_ANALYTICS_DESCRIPTION, (Object)this.cache.getName(), t);
            return new ErrorSessionMetadata();
        }
        return new ApiPlatformSessionMetadata(statusCode);
    }
}

