/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * In charge of routing the analytics event to the correct cache
 */
public class AnalyticsEventDispatcher {

  private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventDispatcher.class);

  private final AnalyticsEventCacheManager cacheManager;

  public AnalyticsEventDispatcher(AnalyticsEventCacheManager cacheManager) {
    this.cacheManager = cacheManager;
  }

  public void dispatch(AnalyticsHttpEvent event) {
    if (isPolicyViolation(event)) {
      processPolicyViolation(event);
    } else {
      cacheManager.getAvailableRegularCaches().forEach(cache -> {
        if (cache.offer(event)) {
          LOGGER.trace("Analytics event successfully added to {}. Event details: {}", cache.getName(), event);
        } else {
          LOGGER.trace("Analytics event was not added to {}. Event details: {}", cache.getName(), event);
        }
      });
    }
  }

  private void processPolicyViolation(AnalyticsHttpEvent event) {
    cacheManager.getAvailablePolicyViolationsCache().forEach(cache -> {
      if (cache.offer(event)) {
        LOGGER.trace("Analytics policy violation event successfully added to {}. Event details: {}", cache.getName(), event);
      } else if (LOGGER.isTraceEnabled()) {
        LOGGER.trace("Analytics policy violation event was not added to {}. Threshold was exceeded. Event details: {}",
                     cache.getName(), event);
      }
    });
  }

  private boolean isPolicyViolation(AnalyticsHttpEvent event) {
    return event.getPolicyViolation() != null;
  }
}
