/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import org.mule.runtime.api.util.MultiMap;

import java.io.Serializable;

public class HttpRequestAttributes implements Serializable {

  private static final long serialVersionUID = 6394672804127284350L;

  private MultiMap<String, String> headers;
  private String requestUri;
  private String method;
  private String remoteAddress;

  public HttpRequestAttributes(MultiMap<String, String> headers, String requestUri, String method, String remoteAddress) {
    this.headers = headers;
    this.requestUri = requestUri;
    this.method = method;
    this.remoteAddress = remoteAddress;
  }

  public MultiMap<String, String> getHeaders() {
    return headers;
  }

  public String getRequestUri() {
    return requestUri;
  }

  public String getMethod() {
    return method;
  }

  public String getRemoteAddress() {
    return remoteAddress;
  }
}
