/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import org.mule.runtime.api.util.MultiMap;

import java.io.Serializable;

public class HttpResponseAttributes implements Serializable {

  private static final long serialVersionUID = 4735030847042331066L;

  private MultiMap<String, String> headers;
  private int statusCode;

  public HttpResponseAttributes(MultiMap<String, String> headers, int statusCode) {
    this.headers = headers;
    this.statusCode = statusCode;
  }

  public MultiMap<String, String> getHeaders() {
    return headers;
  }

  public int getStatusCode() {
    return statusCode;
  }
}
