/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import static java.util.Optional.empty;
import static java.util.Optional.of;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpRequestAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestAttributesFactory {

  private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestAttributesFactory.class);

  private final Introspectors<HttpRequestAttributesIntrospector> introspectors =
      new Introspectors<>(HttpRequestAttributesIntrospector::new);

  public Optional<HttpRequestAttributes> from(TypedValue<Object> attributes) {
    try {
      Object attributesValue = attributes.getValue();
      HttpRequestAttributesIntrospector introspector = introspectors.getFor(attributesValue.getClass());
      MultiMap<String, String> headers = introspector.getHeaders(attributesValue);
      return of(new HttpRequestAttributes(
                                          headers instanceof CaseInsensitiveMultiMap ? headers
                                              : new CaseInsensitiveMultiMap(headers),
                                          introspector.getRequestUri(attributesValue),
                                          introspector.getMethod(attributesValue),
                                          introspector.getRemoteAddress(attributesValue)));
    } catch (Exception e) {
      LOGGER.debug("Can not read HTTP request attributes from attributes of type {}", attributes.getDataType().getType());
    }

    return empty();
  }
}
