/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.notification;

import static org.mule.runtime.api.notification.ConnectorMessageNotification.MESSAGE_ERROR_RESPONSE;
import static org.mule.runtime.api.notification.ConnectorMessageNotification.MESSAGE_RECEIVED;
import static org.mule.runtime.api.notification.ConnectorMessageNotification.MESSAGE_RESPONSE;

import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.api.notification.IntegerAction;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandler;

public class AnalyticsConnectorMessageNotificationListener
    implements ConnectorMessageNotificationListener<ConnectorMessageNotification> {

  private AnalyticsEventHandler eventHandler;

  public AnalyticsConnectorMessageNotificationListener(AnalyticsEventHandler eventHandler) {
    this.eventHandler = eventHandler;
  }

  @Override
  public void onNotification(ConnectorMessageNotification notification) {
    if (isStartNotification(notification)) {
      eventHandler.startEvent(notification);
    } else if (isEndNotification(notification)) {
      eventHandler.finishEvent(notification);
    }
  }

  private boolean isStartNotification(ConnectorMessageNotification notification) {
    return new IntegerAction(MESSAGE_RECEIVED).equals(notification.getAction());
  }

  private boolean isEndNotification(ConnectorMessageNotification notification) {
    return new IntegerAction(MESSAGE_RESPONSE).equals(notification.getAction())
        || new IntegerAction(MESSAGE_ERROR_RESPONSE).equals(notification.getAction());
  }
}
