/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.introspector;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class Introspectors<T> {

  private final Map<String, T> map = new HashMap<>();
  private final Function<Class, T> supplier;

  public Introspectors(Function<Class, T> introspectorSupplier) {
    this.supplier = introspectorSupplier;
  }

  public T getFor(Class cls) {
    String key = cls.getCanonicalName();

    if (!map.containsKey(key)) {
      synchronized (map) {
        if (!map.containsKey(key)) {
          map.put(key, supplier.apply(cls));
        }
      }
    }

    // Not locking for reading may result in some inconsistencies, concurrency exceptions, and other problems, we only
    // synchronize the writing to avoid map structure issues. This was decided due to the small amount of writing
    // with the possibility of the loss of some values during initialization.
    return map.get(key);
  }

  public int size() {
    return map.size();
  }
}
