/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.feedbackloop;

import static java.util.Arrays.stream;
import static java.util.Optional.ofNullable;

import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;

import java.util.List;
import java.util.regex.Pattern;

public class EdgeRequestDetector {

  private static final Pattern VIA_VALUE_REGEX = Pattern.compile("EDGE/\\d+\\.\\d+ MuleSoft");

  public boolean isEdgeRequest(List<String> viaHeaders) {
    return ofNullable(viaHeaders)
        .map(values -> values.stream()
            .flatMap(value -> stream(value.split(",")))
            .anyMatch(value -> VIA_VALUE_REGEX.matcher(value).matches()))
        .orElse(false);
  }
}
