/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.cache;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.when;
import static org.mule.runtime.container.api.MuleFoldersUtil.getExecutionFolder;
import static org.mule.runtime.core.api.config.MuleProperties.MULE_HOME_DIRECTORY_PROPERTY;
import static org.powermock.api.mockito.PowerMockito.mockStatic;
import static org.powermock.api.mockito.PowerMockito.verifyStatic;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;

import java.io.File;
import java.io.IOException;
import java.util.Optional;

import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mapdb.DBMaker;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(PowerMockRunner.class)
@PrepareForTest({DBMaker.class})
@PowerMockIgnore("javax.management.*")
public class AnalyticsEventCacheManagerRecoveryTestCase extends AbstractMuleTestCase {

  @Rule
  public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder(MULE_HOME_DIRECTORY_PROPERTY);

  @Test
  public void createCacheRetriesToCreateIfFailsAtFirstAttempt() throws IOException {
    mockStatic(DBMaker.class);
    File dbFile = new File(getExecutionFolder(), "api-platform-analytics.db");
    File violationsFile = new File(getExecutionFolder(), "api-platform-analytics-policy-violations.db");
    DBMaker dbMaker = mock(DBMaker.class, RETURNS_DEEP_STUBS);

    when(DBMaker.newFileDB(dbFile)).thenThrow(new RuntimeException()).thenReturn(dbMaker);
    when(DBMaker.newFileDB(violationsFile)).thenReturn(dbMaker);

    AnalyticsEventCacheManager manager = new AnalyticsEventCacheManager(new AnalyticsConfiguration());
    manager.initialise();
    Optional<AnalyticsEventCaches> caches = manager.getAgentCaches();

    assertThat(caches.isPresent(), is(true));
    verifyStatic(DBMaker.class, times(2));
    DBMaker.newFileDB(dbFile);
    verifyStatic(DBMaker.class, times(1));
    DBMaker.newFileDB(violationsFile);
  }

}
