/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.extractor;

import static com.mulesoft.mule.runtime.gw.api.security.ClientAuthenticationBuilder.CLIENT_ID_KEY;
import static com.mulesoft.mule.runtime.gw.api.security.ClientAuthenticationBuilder.CLIENT_NAME_KEY;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.security.Authentication;
import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.api.client.Client;

import com.google.common.collect.ImmutableMap;

import java.util.Map;
import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

public class EnrichedServerNotificationExtractorTestCase extends AbstractMuleTestCase {

  private static final String CLIENT_ID = "someId";
  private static final String APPLICATION_NAME = "appName";

  private EnrichedServerNotification notification;

  private EnrichedServerNotificationExtractor extractor;

  @Before
  public void setUp() {
    extractor = new EnrichedServerNotificationExtractor();

    notification = mockNotification();
  }

  @Test
  public void notificationWithAuthenticationWithValidClient() {
    Map<String, Object> properties = ImmutableMap.of(CLIENT_ID_KEY, CLIENT_ID, CLIENT_NAME_KEY, APPLICATION_NAME);
    mockAuthentication(properties);

    Optional<Client> client = extractor.client(notification);

    assertThat(client.isPresent(), is(true));
    assertThat(client.get().id(), is(CLIENT_ID));
    assertThat(client.get().secret(), nullValue());
    assertThat(client.get().name(), is(APPLICATION_NAME));
  }

  @Test
  public void notificationWithoutAuthentication() {
    noAuthentication();

    Optional<Client> client = extractor.client(notification);

    assertThat(client.isPresent(), is(false));
  }

  @Test
  public void notificationWithAuthenticationWithNullProperties() {
    mockAuthentication(null);

    Optional<Client> client = extractor.client(notification);

    assertThat(client.isPresent(), is(false));
  }

  @Test
  public void notificationWithAuthenticationWithoudValidClient() {
    Map<String, Object> properties = ImmutableMap.of("someRandomKey", "someRandomValue");
    mockAuthentication(properties);

    Optional<Client> client = extractor.client(notification);

    assertThat(client.isPresent(), is(false));
  }

  private EnrichedServerNotification mockNotification() {
    EnrichedServerNotification notification = mock(EnrichedServerNotification.class, RETURNS_DEEP_STUBS);
    Event event = mock(Event.class);

    when(notification.getEvent()).thenReturn(event);

    return notification;
  }

  private void mockAuthentication(Map<String, Object> properties) {
    Authentication authentication = mock(Authentication.class);

    when(notification.getEvent().getAuthentication()).thenReturn(of(authentication));
    when(authentication.getProperties()).thenReturn(properties);
  }

  private void noAuthentication() {
    when(notification.getEvent().getAuthentication()).thenReturn(empty());
  }

}
