/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.api;


import static com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsStatus.Status.DISABLED;
import static com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsStatus.Status.ENABLED;

import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsStatus;
import com.mulesoft.mule.runtime.gw.api.analytics.GatewayAnalytics;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;

import java.util.Optional;

public class DefaultGatewayAnalytics implements GatewayAnalytics {

  private final ApiService apiService;

  public DefaultGatewayAnalytics(ApiService apiService) {
    this.apiService = apiService;
  }

  /**
   * Implementation returns an {@link AnalyticsStatus} containing an {@link AnalyticsStatus.Status#ENABLED} when the specified
   * flow contains an API that has been tracked successfully. Otherwise returns an {@link AnalyticsStatus} containing a
   * {@link AnalyticsStatus.Status#DISABLED}
   */
  @Override
  public AnalyticsStatus status(String appName, String flowName) {
    Optional<Api> api = apiService.find(appName, flowName);

    return api.map(value -> value.getTrackingInfo().isTracked() ? new AnalyticsStatus(ENABLED, appName, flowName, value.getKey())
        : new AnalyticsStatus(DISABLED, appName, flowName, value.getKey()))
        .orElseGet(() -> new AnalyticsStatus(DISABLED, appName, flowName, null));

  }
}
