/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.backoff;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;

import java.util.function.Supplier;

public class AnalytictsBackoffConfigurationSupplier implements Supplier<BackoffConfiguration> {

  public static final double BASE = 2;
  public static final double MULTIPLIER = 5;
  public static final double DISPERSION = 0.45;

  public BackoffConfiguration get() {
    GatewayConfiguration gatewayConfiguration = new GatewayConfiguration();
    BackoffConfiguration.Builder builder =
        new BackoffConfiguration.Builder(gatewayConfiguration.platformClient().backoffEnabled());
    builder.statusCodes(gatewayConfiguration.platformClient().getOutagesStatusCodes());
    builder.backoff(BASE, MULTIPLIER, DISPERSION, 3);
    builder.backon(BASE, MULTIPLIER, DISPERSION, 2);
    builder.statusCodes(new AnalyticsConfiguration().getOutagesStatusCodes().toArray(new Integer[] {}));
    return builder.build();
  }
}
