/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.extractor;

import static com.hazelcast.util.Preconditions.checkNotNull;

import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.core.privileged.event.BaseEventContext;

/**
 * Extracts information needed by analytics from the server notification
 */
public class EnrichedServerNotificationEventIdExtractor {

  public String eventId(EnrichedServerNotification notification) {
    checkNotNull(notification, "Notification cannot be null");
    return ((BaseEventContext) notification.getEvent().getContext()).getRootContext().getId();
  }
}
