/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.introspector;

import static org.apache.commons.lang3.reflect.FieldUtils.getField;

import org.mule.runtime.api.util.MultiMap;

import java.lang.reflect.Field;

public class HttpAttributesIntrospector {

  private final Field headersField;

  public HttpAttributesIntrospector(Class cls) {
    this.headersField = getField(cls, "headers", true);
  }

  public MultiMap<String, String> getHeaders(Object httpAttribute) throws IllegalAccessException {
    return (MultiMap<String, String>) headersField.get(httpAttribute);
  }

  public Field getHeadersField() {
    return headersField;
  }
}
