/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import static java.util.Optional.empty;
import static java.util.Optional.of;

import java.util.Optional;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpResponseAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;

public class HttpResponseAttributesFactory {

  private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseAttributesFactory.class);
  private final Introspectors<HttpResponseAttributesIntrospector> introspectors =
      new Introspectors<>(HttpResponseAttributesIntrospector::new);

  public Optional<HttpResponseAttributes> from(TypedValue<Object> attributes) {
    try {
      Object attributesValue = attributes.getValue();
      HttpResponseAttributesIntrospector introspector = introspectors.getFor(attributesValue.getClass());
      MultiMap<String, String> headers = introspector.getHeaders(attributesValue);
      return of(new HttpResponseAttributes(headers instanceof CaseInsensitiveMultiMap ? headers
          : new CaseInsensitiveMultiMap(headers),
                                           introspector.getStatusCode(attributesValue)));
    } catch (Exception e) {
      LOGGER.trace("Can not read HTTP response Attributes from attributes of type {}", attributes.getDataType().getType());
    }

    return empty();
  }
}
