/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.notification;

import static java.util.Optional.empty;
import static java.util.Optional.of;

import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import org.mule.runtime.api.notification.NotificationListener;

import com.mulesoft.mule.runtime.gw.api.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSupplier;

import java.util.Optional;

/**
 * Supplies a {@link AnalyticsPolicyNotificationListener} only for online policies
 */
public class AnalyticsNotificationListenerSupplier implements PolicyNotificationListenerSupplier {

  private final EventsCollectorService eventsCollectorService;

  public AnalyticsNotificationListenerSupplier(EventsCollectorService eventsCollectorService) {
    this.eventsCollectorService = eventsCollectorService;
  }

  @Override
  public Optional<NotificationListener> supply(ApiImplementation apiImplementation, PolicyDefinition policyDefinition,
                                               PolicySpecification policySpecification) {
    NotificationListener notificationListener =
        new AnalyticsPolicyNotificationListener(eventsCollectorService,
                                                policyDefinition.getId(),
                                                policyDefinition.getName(),
                                                policySpecification.getViolationCategory());

    return policyDefinition.isOnline() ? of(notificationListener) : empty();
  }
}
