/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.feedbackloop;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.util.MultiMap;

import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributes;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;

import org.junit.Test;

public class FeedbackLoopDDOSHeaderInjectorTestCase {

  private static final String X_MULE_DDOS_VIOLATION = "X-MULE-DDOS-VIOLATION";
  private PolicyViolation violation =
      PolicyViolation.builder().withPolicyId("id").withPolicyName("name").withCategory("testCategory").build();
  private FeedbackLoopDDOSHeaderInjector injector = new FeedbackLoopDDOSHeaderInjector();

  @Test
  public void injectHeader() {

    HttpResponseAttributes attributes = new HttpResponseAttributes(MultiMap.emptyMultiMap(), 200);
    TestAttributeClass testAttributes = new TestAttributeClass();
    TestAttributeClass testAttributes2 = new TestAttributeClass();

    injector.injectHeader(attributes, violation);
    injector.injectHeader(testAttributes, violation);
    injector.injectHeader(testAttributes2, violation);

    assertThat(attributes.getStatusCode(), is(200));
    assertThat(attributes.getHeaders().get(X_MULE_DDOS_VIOLATION), is(violation.getCategory()));
    assertThat(testAttributes.headers.get(X_MULE_DDOS_VIOLATION), is(violation.getCategory()));
    assertThat(testAttributes2.headers.get(X_MULE_DDOS_VIOLATION), is(violation.getCategory()));
  }
}
