/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpResponseAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributes;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseAttributesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseAttributesFactory.class);
    private final Introspectors<HttpResponseAttributesIntrospector> introspectors = new Introspectors<HttpResponseAttributesIntrospector>(HttpResponseAttributesIntrospector::new);

    public Optional<HttpResponseAttributes> from(TypedValue<Object> attributes) {
        try {
            Object attributesValue = attributes.getValue();
            HttpResponseAttributesIntrospector introspector = this.introspectors.getFor(attributesValue.getClass());
            CaseInsensitiveMultiMap headers = introspector.getHeaders(attributesValue);
            return Optional.of(new HttpResponseAttributes((MultiMap<String, String>)(headers instanceof CaseInsensitiveMultiMap ? headers : new CaseInsensitiveMultiMap((MultiMap)headers)), introspector.getStatusCode(attributesValue)));
        }
        catch (Exception e) {
            LOGGER.trace("Can not read HTTP response Attributes from attributes of type {}", (Object)attributes.getDataType().getType());
            return Optional.empty();
        }
    }
}

