/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.injector;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderInjector {

  private static final Logger LOGGER = LoggerFactory.getLogger(HeaderInjector.class);

  private final Introspectors<HttpAttributesIntrospector> introspectors =
      new Introspectors<>(HttpAttributesIntrospector::new);

  protected void injectHeader(Object attributes, String name, String value) {
    try {
      HttpAttributesIntrospector introspector = introspectors.getFor(attributes.getClass());
      MultiMap<String, String> headers = new CaseInsensitiveMultiMap(introspector.getHeaders(attributes));
      headers.put(name, value);
      introspector.getHeadersField().set(attributes, headers);
    } catch (IllegalAccessException e) {
      LOGGER.debug(String.format("Could not set header \"%s\": \"%s\" for the response event.", name, value), e);
    }
  }
}
