/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics.introspector;

import static org.apache.commons.lang3.reflect.MethodUtils.getAccessibleMethod;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HttpRequestAttributesIntrospector extends HttpAttributesIntrospector {

  private final Method requestUriMethod;
  private final Method methodMethod;
  private final Method remoteAddressMethod;

  public HttpRequestAttributesIntrospector(Class cls) {
    super(cls);
    this.requestUriMethod = getAccessibleMethod(cls, "getRequestUri");
    this.methodMethod = getAccessibleMethod(cls, "getMethod");
    this.remoteAddressMethod = getAccessibleMethod(cls, "getRemoteAddress");
  }

  public String getRequestUri(Object attributesValue) throws InvocationTargetException, IllegalAccessException {
    return (String) requestUriMethod.invoke(attributesValue);
  }

  public String getMethod(Object attributesValue) throws InvocationTargetException, IllegalAccessException {
    return (String) methodMethod.invoke(attributesValue);
  }

  public String getRemoteAddress(Object attributesValue) throws InvocationTargetException, IllegalAccessException {
    return (String) remoteAddressMethod.invoke(attributesValue);
  }
}
