/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import static java.util.Collections.singletonList;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;

import org.junit.Before;
import org.junit.Test;

public class AnalyticsEventDispatcherTestCase extends AbstractMuleTestCase {

  private AnalyticsEventCache regularEventCache;
  private AnalyticsEventCache violationsCache;

  private AnalyticsEventDispatcher eventDispatcher;

  @Before
  public void setUp() {
    AnalyticsEventCacheManager manager = mock(AnalyticsEventCacheManager.class);
    this.regularEventCache = mock(AnalyticsEventCache.class, RETURNS_DEEP_STUBS);
    this.violationsCache = mock(AnalyticsEventCache.class, RETURNS_DEEP_STUBS);

    when(manager.getAvailableRegularCaches()).thenReturn(singletonList(regularEventCache));
    when(manager.getAvailablePolicyViolationsCache()).thenReturn(singletonList(violationsCache));

    this.eventDispatcher = new AnalyticsEventDispatcher(manager);
  }

  @Test
  public void dispatchEvent() {
    AnalyticsHttpEvent event = mock(AnalyticsHttpEvent.class);

    eventDispatcher.dispatch(event);

    verify(regularEventCache).offer(event);
    verify(violationsCache, never()).offer(event);
  }

  @Test
  public void dispatchEventWithViolation() {
    AnalyticsHttpEvent event = mock(AnalyticsHttpEvent.class);
    when(event.getPolicyViolation()).thenReturn(mock(PolicyViolation.class));
    when(event.getStatusCode()).thenReturn(500);

    eventDispatcher.dispatch(event);

    verify(violationsCache).offer(eq(event));
    verify(regularEventCache, never()).offer(event);
  }
}
