/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventDispatcher;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.AnalyticsServiceMeshEventHandler;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.analytics.extractor.EnrichedServerNotificationExtractor;
import com.mulesoft.mule.runtime.gw.api.events.collector.service.EventsCollectorService;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnalyticsEventHandlerManager {
    private final ApiService apiService;
    private final AnalyticsEventCacheManager cacheManager;
    private final Boolean serviceMesh;
    private final Map<String, AnalyticsEventHandler> handlers;
    private EventsCollectorService eventsCollectorService;
    private Optional<GatewayMetricsAdapter> metricsCollector;

    public AnalyticsEventHandlerManager(ApiService apiService, AnalyticsEventCacheManager cacheManager, EventsCollectorService eventsCollectorService, Boolean serviceMesh, Optional<GatewayMetricsAdapter> metricsCollector) {
        this.apiService = apiService;
        this.cacheManager = cacheManager;
        this.serviceMesh = serviceMesh;
        this.handlers = new HashMap<String, AnalyticsEventHandler>();
        this.eventsCollectorService = eventsCollectorService;
        this.metricsCollector = metricsCollector;
    }

    public AnalyticsEventHandler create(String appName) {
        EnrichedServerNotificationExtractor extractor = new EnrichedServerNotificationExtractor();
        AnalyticsEventHandler handler = this.serviceMesh != false ? new AnalyticsServiceMeshEventHandler(appName, this.apiService, extractor, this.eventsCollectorService) : new AnalyticsEventHandler(appName, this.apiService, extractor, new AnalyticsEventDispatcher(this.cacheManager), this.eventsCollectorService, this.metricsCollector);
        this.handlers.put(appName, handler);
        return handler;
    }

    public AnalyticsEventHandler get(String appName) {
        return this.handlers.get(appName);
    }

    public void remove(String appName) {
        this.handlers.remove(appName);
    }
}

