/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.notification;

import com.mulesoft.mule.runtime.gw.analytics.extractor.EnrichedServerNotificationEventIdExtractor;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpResponseAttributesFactory;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpStatusCodeMatcher;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolationOutcome;
import com.mulesoft.mule.runtime.gw.api.events.collector.service.EventsCollectorService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.api.notification.PolicyNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsPolicyNotificationListener
implements PolicyNotificationListener<PolicyNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsPolicyNotificationListener.class);
    private final String policyName;
    private final String policyId;
    private final String violationCategory;
    private final HttpStatusCodeMatcher statusCodeMatcher;
    private final EnrichedServerNotificationEventIdExtractor eventIdExtractor = new EnrichedServerNotificationEventIdExtractor();
    private Map<String, Integer> statusCodePerEvent = new ConcurrentHashMap<String, Integer>();
    private EventsCollectorService eventsCollectorService;
    private final HttpResponseAttributesFactory httpResponseAttributesFactory = new HttpResponseAttributesFactory();

    public AnalyticsPolicyNotificationListener(EventsCollectorService eventsCollectorService, String policyId, String policyName, String violationCategory) {
        this.policyId = policyId;
        this.policyName = policyName;
        this.statusCodeMatcher = new HttpStatusCodeMatcher();
        this.eventsCollectorService = eventsCollectorService;
        this.violationCategory = violationCategory;
    }

    public void onNotification(PolicyNotification notification) {
        String eventId = this.eventIdExtractor.eventId((EnrichedServerNotification)notification);
        if (this.isAfterNext(notification)) {
            this.httpResponseAttributesFactory.from((TypedValue<Object>)notification.getEvent().getMessage().getAttributes()).ifPresent(attributes -> this.statusCodePerEvent.put(eventId, attributes.getStatusCode()));
        } else if (this.isProcessEnd(notification)) {
            Integer previousStatusCode = this.statusCodePerEvent.remove(eventId);
            this.httpResponseAttributesFactory.from((TypedValue<Object>)notification.getEvent().getMessage().getAttributes()).ifPresent(attributes -> {
                Integer currentStatusCode = attributes.getStatusCode();
                if (this.isPolicyViolation(previousStatusCode, currentStatusCode)) {
                    this.handleViolation(eventId, this.policyId, this.policyName);
                } else if (this.eventsCollectorService.getPolicyViolation(eventId).isPresent() && currentStatusCode < 400) {
                    this.eventsCollectorService.removePolicyViolation(eventId);
                }
            });
        }
    }

    private void handleViolation(String eventId, String policyId, String policyName) {
        LOGGER.debug("Processing Policy Violation Notification for '{}'", (Object)policyName);
        PolicyViolation policyViolation = PolicyViolation.builder().withPolicyId(policyId).withPolicyName(policyName).withOutcome(PolicyViolationOutcome.VIOLATION).withCategory(this.violationCategory).build();
        this.eventsCollectorService.addPolicyViolation(eventId, policyViolation);
    }

    private boolean isPolicyViolation(Integer previousStatusCode, Integer currentstatusCode) {
        return (previousStatusCode == null || !this.statusCodeMatcher.isError(previousStatusCode)) && this.statusCodeMatcher.isError(currentstatusCode);
    }

    private boolean isAfterNext(PolicyNotification notification) {
        return new IntegerAction(2103).equals((Object)notification.getAction());
    }

    private boolean isProcessEnd(PolicyNotification notification) {
        return new IntegerAction(2104).equals((Object)notification.getAction());
    }
}

