/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.logger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.mule.runtime.gw.analytics.logger.AnalyticsEventLogger;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.client.model.HttpEvent;
import com.mulesoft.mule.runtime.gw.client.model.HttpEventViews;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsHttpEventsLogger
implements AnalyticsEventLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsHttpEventsLogger.class);
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);

    public AnalyticsHttpEventsLogger() {
        this.objectMapper.setConfig(this.objectMapper.getSerializationConfig().withView(HttpEventViews.LogAnalytics.class));
    }

    @Override
    public void logEvent(AnalyticsHttpEvent event) {
        try {
            String message = this.objectMapper.writeValueAsString((Object)HttpEvent.from((AnalyticsHttpEvent)event));
            LOGGER.info(message);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unexpected error serializing Analytics event", (Throwable)e);
        }
    }
}

