/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.DefaultApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class ApiContractSupplierTestCase {
    private ApiService apiService;
    private Api api;
    private Api anotherApi;
    private ContractService contractService;
    private ApiTrackingService apiTrackingService;

    @Before
    public void setUp() {
        this.apiService = new DefaultApiService((DeploymentService)Mockito.mock(DeploymentService.class));
        this.contractService = (ContractService)Mockito.mock(ContractService.class);
        this.apiTrackingService = new DefaultApiTrackingService(this.apiService, null, null, null, this.contractService, null);
        this.api = new Api(this.key(), null, null);
        this.anotherApi = new Api(this.anotherKey(), null, null);
    }

    @Test
    public void emptyTrackedAndContracts() {
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.empty());
    }

    @Test
    public void checkApisNotTracked() {
        this.add(this.api, this.anotherApi);
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.empty());
    }

    @Test
    public void checkTrackedApiButWithoutContracts() {
        this.addTwoApisAndSetOneAsTracked();
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.is(Arrays.asList(this.api)));
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.empty());
    }

    @Test
    public void checkWithContractsButNotTracked() {
        this.add(this.api);
        this.track(this.api.getKey());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.empty());
    }

    @Test
    public void trackedWithContracts() {
        this.addTwoApisAndSetOneAsTracked();
        this.track(this.api.getKey());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.is(Arrays.asList(this.api)));
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.is(Arrays.asList(this.api)));
    }

    @Test
    public void trackMultipleApis() {
        this.add(this.api, this.anotherApi);
        this.track(this.api.getKey(), this.anotherApi.getKey());
        this.api.updateTrackingInfo((TrackingInfo)this.tracked());
        this.anotherApi.updateTrackingInfo((TrackingInfo)this.tracked());
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApis(), (Matcher)Matchers.is(Arrays.asList(this.anotherApi, this.api)));
        MatcherAssert.assertThat((Object)this.apiTrackingService.getTrackedApisRequiringContracts(), (Matcher)Matchers.is(Arrays.asList(this.anotherApi, this.api)));
    }

    private void addTwoApisAndSetOneAsTracked() {
        this.add(this.api, this.anotherApi);
        this.api.updateTrackingInfo((TrackingInfo)this.tracked());
    }

    private ApiTrackingInfo tracked() {
        return new ApiTrackingInfo(Long.valueOf(1L), "", "", "", "", "", "", "", Integer.valueOf(99), "", "", "", "", "");
    }

    private ApiContractSupplierTestCase track(ApiKey ... keys) {
        Mockito.when((Object)this.contractService.trackedApis()).thenReturn(Arrays.asList(keys));
        return this;
    }

    private ApiContractSupplierTestCase add(Api ... apis) {
        for (Api api : apis) {
            Map apisWithinService = (Map)new Inspector((Object)this.apiService).read("apis");
            apisWithinService.put(api.getKey(), api);
            VariableOverride.overrideVariable((String)"apis").in((Object)this.apiService).with((Object)apisWithinService);
        }
        return this;
    }

    private ApiKey anotherKey() {
        return PolicyTestValuesConstants.API_KEY_2;
    }

    private ApiKey key() {
        return PolicyTestValuesConstants.API_KEY;
    }
}

